#version 150

#moj_import <fog.glsl>

uniform sampler2D Sampler0;

uniform vec4 ColorModulator;
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;

in float vertexDistance;
in vec4 vertexColor;
in vec2 texCoord0;
in vec2 texCoord1;
in vec3 pos;

out vec4 fragColor;

vec3 encode(int value) {
    return vec3((value >> 16) & 0xFF, (value >> 8) & 0xFF, value & 0xFF);
}

int decode(vec3 value) {
    int x = int(round(value.x));
    int y = int(round(value.y));
    int z = int(round(value.z));

    return (x << 16) | (y << 8) | z;
}

vec2 to_pixel_cord(vec2 texture_size, vec2 texture_cord) {
    return texture_cord * texture_size;
}

vec2 to_uv_cord(vec2 texture_size, vec2 pixel_cord) {
    return pixel_cord / texture_size;
}

vec2 cube_face(float size, float face) {
    int f = int(face);
    
    switch (f) {
        case 0: return vec2(0.0,    size);
        case 1: return vec2(size,  size);
        case 2: return vec2(size,    0.0);
        case 3: return vec2(size * 2,   0.0);
        case 4: return vec2(size * 2, size);
        case 5: return vec2(size * 3, size);
    }

    return vec2(0.0);
}

void main() {
    // const float size = 512.0;

    vec4 color = texture(Sampler0, texCoord0) * vertexColor * ColorModulator;
    
    if (color.a < 0.1) {
        discard;
    }
    
    fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);
    vec2 texture_size = textureSize(Sampler0,0);
    ivec2 pixel_coord = ivec2(round(texCoord0 * texture_size));
    ivec2 size_pixel_coord = pixel_coord + ivec2(1, 0);
    float skybox = round(texelFetch(Sampler0, pixel_coord,0).a * 100);
    vec3 funny_color = vec3(round(texelFetch(Sampler0, pixel_coord,0).rgb * 255));
    vec3 size_vec = round(texelFetch(Sampler0, size_pixel_coord, 0).rgb * 255);
    float size = float(decode(size_vec));

    if ((int(round(size)) % 2) != 0) {
        size = 512.0;
    }

    if (skybox == 58 && funny_color == vec3(69,42,5)) {


        // direction to face
        vec3 dir = normalize(pos.xyz);
        vec3 absDir = abs(dir);
        float maxAxis;
        vec2 uv;
        float face = 0.0;
        
        // face logic
        if (absDir.x >= absDir.y && absDir.x >= absDir.z) {
            maxAxis = absDir.x;
            uv = vec2(dir.z, dir.y) / maxAxis;
            face = dir.x > 0.0 ? 0.0 : 1.0;
        } else if (absDir.y >= absDir.x && absDir.y >= absDir.z) {
            maxAxis = absDir.y;
            uv = vec2(dir.x, -dir.z) / maxAxis;
            face = dir.y > 0.0 ? 2.0 : 3.0;
        } else {
            maxAxis = absDir.z;
            uv = vec2(dir.x, dir.y) / maxAxis;
            face = dir.z > 0.0 ? 4.0 : 5.0;
        }
        
        // convert [-1,1] to [0,1]
        uv = uv * 0.5 + 0.5;
        
        // flip Y to match texture atlas layout
        uv.y = 1 - uv.y;
        if (mod(face,2)==1) {
            uv.x = 1-uv.x;
        }
        if (face >= 4) {
            uv.x = 1-uv.x;
        }
        if (face >= 2 && face <= 3) {
            uv.x = 1-uv.x;
        }

        
        vec2 AtlasSize = textureSize(Sampler0,0);
        vec2 faceOffset = cube_face(size, face);
        faceOffset = faceOffset / AtlasSize;

        vec2 one_face = size / AtlasSize;
        uv *= one_face;

        vec2 final_uv = texCoord0+faceOffset;
        final_uv += uv;

        fragColor = texture(Sampler0, final_uv);
    }

}
