#include <stdio.h>

struct RGB {
    int r;
    int g;
    int b;
} RGB;

struct RGB encode(int value) {
    int r = (value >> 16) & 0xFF;
    int g = (value >> 8) & 0xFF;
    int b = value & 0xFF;

    struct RGB rgb = {
        .r = r,
        .g = g,
        .b = b,
    };

    return rgb;
}

int decode(struct RGB rgb) {
    return (rgb.r << 16) | (rgb.g << 8) | rgb.b;
}

int main(int argc, char** argv) {
    int size = 4096;
    struct RGB rgb = encode(size);
    int decoded = decode(rgb);

    printf("Size: %i\n", size);
    printf("R: %i | G: %i | B: %i\n", rgb.r, rgb.g, rgb.b);
    printf("Decoded: %i\n", decoded);

    return 0;
}
