# -Z = front
# +Z = back
# -Y = bottom
# +Y = top
# -X = right
# +X = left

from PIL import Image

SIZE = 2048

TOP_LOC = (SIZE, 0)
BOTTOM_LOC = (SIZE * 2, 0)
FRONT_LOC = (SIZE * 3, SIZE)
BACK_LOC = (SIZE * 2, SIZE)
LEFT_LOC = (SIZE, SIZE)
RIGHT_LOC = (0, SIZE)

def encode(value: int) -> tuple[int, int, int]:
    return ((value >> 16) & 0xFF, (value >> 8) & 0xFF, value & 0xFF)

def place(img: Image.Image, name: str, loc: tuple[int, int], mode: Image.Transpose | None = None, mode2: Image.Transpose | None = None):
    it = Image.open(name, "r")
    it = it.resize((SIZE, SIZE))

    if mode is not None:
        it = it.transpose(mode)
    
    if mode2 is not None:
        it = it.transpose(mode2)

    # it = it.crop((0, 0, SIZE, SIZE))
    img.paste(it, loc)
    
    return it

img = Image.new("RGBA", (SIZE * 4, SIZE * 2))
img.putpixel((0, 0), (69, 42, 5, round(0.58 * 255)))
img.putpixel((1, 0), encode(SIZE))

place(img, "top.png", TOP_LOC, Image.Transpose.FLIP_TOP_BOTTOM, Image.Transpose.FLIP_LEFT_RIGHT)
place(img, "bottom.png", BOTTOM_LOC)
place(img, "left.png", LEFT_LOC)
place(img, "right.png", RIGHT_LOC)
place(img, "front.png", FRONT_LOC)
place(img, "back.png", BACK_LOC)

img.save("assets/minecraft/textures/item/skybox4.png")
